import math

def pw_shape_tention_mem(p_dead=None,p_live=None,fyk=None,,fu=None, ):
    """
    Select an 8 in. W-shape, ASTM A992, to carry a dead load of 30 kips and a live load of 90 kips in tension.  The 
    member is 25 ft long. Verify the member strength by both LRFD and ASD with the bolted end connection shown.  
    Verify that the member satisfies the recommended slenderness limit. 
    """
    p_u =1.2*p_dead + 1.6*p_live  
    A = Q / max_velocity  # Required area in m²
    D = math.sqrt(4 * A / math.pi)  # Diameter in meters
      
    return round(D * 1000, 1)  # Return diameter in mm


if __name__ == "__main__":
    # Example usage
    flow = 757  # L/s
    required_diameter = pipe_diameter_for_velocity(flow)
    print(f"Required internal diameter to keep velocity ≤ 3 m/s: {required_diameter} mm")


import math

import math

def pressure_drop_mscl(flow_lps, diameter_mm, length_m):
    # Constants
    epsilon = 0.00003  # pipe roughness in m (0.03 mm for cement-lined steel)
    rho = 998          # water density in kg/m^3
    mu = 0.001         # dynamic viscosity in Pa·s
    g = 9.81           # gravity in m/s²

    # Convert units
    Q = flow_lps / 1000         # flow rate in m³/s
    D = diameter_mm / 1000      # diameter in m
    A = math.pi * (D**2) / 4    # area in m²
    v = Q / A                   # velocity in m/s
    Re = rho * v * D / mu       # Reynolds number

    # Swamee-Jain equation for friction factor (turbulent flow)
    if Re < 2000:
        raise ValueError("Flow is laminar; Swamee-Jain not valid.")
    f = 0.25 / (math.log10(epsilon / (3.7 * D) + 5.74 / Re**0.9))**2

    # Darcy–Weisbach equation for head loss
    hf = f * (length_m / D) * (v**2 / (2 * g))  # in meters of water
    delta_p = rho * g * hf  # pressure drop in Pascals

    return {
        "velocity_mps": v,
        "reynolds": Re,
        "friction_factor": f,
        "head_loss_m": hf,
        "pressure_drop_kpa": delta_p / 1000
    }

# Test block
if __name__ == "__main__":
    test = pressure_drop_mscl(flow_lps=20, diameter_mm=200, length_m=100)
    for k, v in test.items():
        print(f"{k}: {v:.3f}")

